<?php 
require $_SERVER['DOCUMENT_ROOT'].'/system/includes/Header.php';
?>
<?php 
if ($userChk['isAdmin'] != '1') { ?>
    <meta http-equiv="refresh" content="0; url=<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/home"> 
	<?php die(); 
} 
?>
        <div class="content-body">
            <!-- row -->	
			<div class="page-titles">
				<nav aria-label="breadcrumb">
				  <ol class="breadcrumb">
					<li class="breadcrumb-item ps-0"><a href="<?php echo "https://" . $_SERVER['SERVER_NAME']; ?>/users"><?=$translations["users"]?></a></li>
					<li class="breadcrumb-item active" aria-current="page"><?=$translations["userAdd"]?></li>
				  </ol>
				</nav>
				</div>
				<div class="container-fluid">
				
                <!-- row -->
                <div class="row">
                    <div class="col-xl-6 col-lg-12">
                        <div class="card">
						<div class="card-header flex-wrap d-flex justify-content-between">
                        <h4 class="card-title"><?=$translations["userAdd"]?></h4>
                            </div>
                            <div class="card-body">
                                <div class="basic-form">
                                    <form id="UserAddForm">
										<div class="mb-3 row">
                                            <label class="col-sm-3 col-form-label" for="name"><?=$translations["userName"]?></label>
                                            <div class="col-sm-9">
                                            <input type="text" class="form-control" id="name" name="name">
                                            </div>
                                        </div>
										<div class="mb-3 row">
                                            <label class="col-sm-3 col-form-label" for="email"><?=$translations["userEmail"]?></label>
                                            <div class="col-sm-9">
                                            <input type="email" class="form-control" id="email" name="email">
                                            </div>
                                        </div>
                                        <div class="mb-3 row">
                                            <label class="col-sm-3 col-form-label" for="password"><?=$translations["userPassword"]?></label>
                                            <div class="col-sm-9">
                                            <input type="password" class="form-control" id="password" name="password">
                                            </div>
                                        </div>
                                        <div class="mb-3 row">
                                            <label class="col-sm-3 col-form-label" for="phone"><?=$translations["userPhone"]?></label>
                                            <div class="col-sm-9">
                                            <input type="phone" class="form-control" id="phone" name="phone">
                                            </div>
                                        </div>
                                        <div class="mb-3 row">
                                            <label class="col-sm-3 col-form-label" for="department"><?=$translations["userDepartment"]?></label>
                                            <div class="col-sm-9">
                                            <select class="default-select  form-control wide" id="department" name="department">
                                            <?php $department = $DB->query("SELECT * from departments order by id desc")->fetchAll(PDO::FETCH_ASSOC); 
                                                foreach ($department as $departmentCek) {
                                                    ?>
                                                  <option value="<?=$departmentCek['id']?>"><?=$departmentCek['name']?></option>
                                                <?php } ?>
                                            </select>
                                            </div>
                                        </div>
                                        <?php if($userChk['isAdmin']=='1') { ?> 
                                        <div class="mb-3 row">
                                                    <label class="col-sm-3 col-form-label" for="isAdmin"><?=$translations["admin"]?></label>
                                                <div class="col-sm-9">
                                                    <div class="form-check form-switch form-check-primary">
                                                        <input type="checkbox" class="form-check-input" id="isAdmin"
                                                            name="isAdmin">
                                                        <label class="form-check-label" for="isAdmin">
                                                            <span class="switch-icon-left"></span>
                                                            <span class="switch-icon-right"></span>
                                                        </label>
                                                    </div> </div>
                                                </div>
                                                <?php } ?>

											<div class="col-sm-9 offset-sm-3">
                                            <input type="hidden" name="UserAdd" value="1">
                                            <button id="UserAdd" type="button"
                                                class="btn btn-primary me-1"><?=$translations["add"]?></button>
                                            <a href="/users"><button type="button"
                                                    class="btn btn-outline-secondary"><?=$translations["back"]?></button></a>
                                        </div>
                                    </form>
                                </div>
                            </div></div>
                        
					</div></div></div>
</div></div>

<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
	$("#UserAdd").click(function() {
        if ($('#name').val() == '') {
        Swal.fire({
            title: "<?=$translations["error"]?>",
            text: "<?=$translations["userNameError"]?>",
            icon: 'error',
            confirmButtonColor: '#7367f0',
            confirmButtonText: "<?=$translations["ok"]?>"

        });
    } else if ($('#email').val() == '') {
        Swal.fire({
            title: "<?=$translations["error"]?>",
            text: "<?=$translations["userEmailError"]?>",
            icon: 'error',
            confirmButtonColor: '#7367f0',
            confirmButtonText: "<?=$translations["ok"]?>"

        });

    } else if ($('#password').val() == '') {
        Swal.fire({
            title: "<?=$translations["error"]?>",
            text: "<?=$translations["userPasswordError"]?>",
            icon: 'error',
            confirmButtonColor: '#7367f0',
            confirmButtonText: "<?=$translations["ok"]?>"

        });
    } else {
        var title = "<?=$translations["congratulations"]?>";
        var text = "<?=$translations["userSuccess"]?>";
        var form = $('#UserAddForm')[0];
        var data = new FormData(form);
        $.ajax({
            type: 'post',
            url: 'mercury',
            data: data,
            enctype: 'multipart/form-data',
            processData: false,
            contentType: false,
            cache: false,
            success: function() {
                Swal.fire({
                    title: title,
                    text: text,
                    icon: 'success',
                    confirmButtonColor: '#red',
                    confirmButtonText: "<?=$translations["ok"]?>"

                }).then((result) => {
                    if (result.isConfirmed) {
                        location.reload();
                    }
                    if (result.isDismissed) {
                        location.reload();
                    }
                })

            }
        });
    }

});
</script>
<?php
require $_SERVER['DOCUMENT_ROOT'].'/system/includes/Footer.php';
?>